/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.common.qos.config;

import com.sun.jbi.common.qos.I18n;
import com.sun.jbi.common.qos.config.AppConfig;
import com.sun.jbi.common.qos.config.AppVar;
import com.sun.jbi.common.qos.config.ComponentConfig;
import com.sun.jbi.common.qos.config.Property;
import com.sun.jbi.common.util.Util;
import com.sun.jbi.common.xml.StackableParser;
import java.util.Iterator;
import javax.jbi.management.DeploymentException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AppPersistenceParser
extends StackableParser {
    public static final String APP_ROOT_ELEM = "app";
    public static final String CONFIG_ELEM = "config";
    public static final String PROPERTY_ELEM = "property";
    public static final String VAR_ELEM = "var";
    public static final String VALUE_ELEM = "value";
    public static final String NAME_ATTR = "name";
    public static final String TYPE_ATTR = "type";
    private ComponentConfig mConfig = null;
    private AppConfig mAppConfig = null;
    private Property mProperty = null;
    private AppVar mVar = null;

    public AppPersistenceParser(ComponentConfig config) {
        this.mConfig = config;
    }

    public void endElement(String uri, String localName, String qname) throws SAXException {
        this.updateContent(this);
        if (qname.equals(CONFIG_ELEM)) {
            this.mConfig.putAppConfig(this.mAppConfig);
            this.mAppConfig = null;
        } else if (qname.equals(PROPERTY_ELEM)) {
            this.mProperty = null;
        } else if (qname.equals(VALUE_ELEM)) {
            String value = this.getContent();
            this.mProperty.addValue(value);
        } else if (qname.equals(VAR_ELEM)) {
            this.mVar.setValue(this.getContent());
            this.mConfig.putAppVar(this.mVar);
            this.mVar = null;
        }
    }

    public void startElement(String uri, String localName, String qname, Attributes attr) throws SAXException {
        if (qname.equals(CONFIG_ELEM)) {
            String acName = this.getAttrValue(attr, NAME_ATTR);
            this.mAppConfig = new AppConfig(acName, this.mConfig.getAppConfigDefs());
        } else if (qname.equals(PROPERTY_ELEM)) {
            String propName = this.getAttrValue(attr, NAME_ATTR);
            this.mProperty = this.mAppConfig.getProperty(propName);
        } else if (qname.equals(VALUE_ELEM)) {
            this.updateContent(this);
        } else if (qname.equals(VAR_ELEM)) {
            this.updateContent(this);
            AppVar.VarType type = AppVar.VarType.valueOf(this.getAttrValue(attr, TYPE_ATTR));
            this.mVar = new AppVar(this.getAttrValue(attr, NAME_ATTR), "", type);
        }
    }

    String getAttrValue(Attributes attr, String name) throws SAXException {
        String val = attr.getValue(name);
        if (Util.isEmpty((String)val)) {
            throw this.error(null, "Missing required attribute: {0}", name);
        }
        return val;
    }

    private SAXException error(Exception e, String msg, Object ... params) {
        String err = I18n.loc(msg, params);
        if (e == null) {
            return new SAXException((Exception)new DeploymentException(err));
        }
        return new SAXException(err, e);
    }

    static String toAppXml(ComponentConfig config) {
        StringBuffer buff = new StringBuffer();
        buff.append("<").append(APP_ROOT_ELEM).append(">\n");
        if (config != null) {
            Iterator<String> iter;
            if (config.supportsAppConfigs()) {
                iter = config.appConfigNames();
                while (iter.hasNext()) {
                    AppConfig ac = config.getAppConfig(iter.next());
                    buff.append("\t<").append(CONFIG_ELEM).append(" ").append(NAME_ATTR).append("=\"").append(ac.getName()).append("\">\n");
                    for (Property prop : ac.propertySet()) {
                        if (prop.count() <= 0) continue;
                        buff.append("\t\t<").append(PROPERTY_ELEM).append(" ").append(NAME_ATTR).append("=\"").append(prop.getName()).append("\">\n");
                        int n = prop.count();
                        for (int i = 0; i < n; ++i) {
                            buff.append("\t\t\t<").append(VALUE_ELEM).append(">").append(prop.getValueAt(i)).append("</").append(VALUE_ELEM).append(">\n");
                        }
                        buff.append("\t\t</").append(PROPERTY_ELEM).append(">\n");
                    }
                    buff.append("\t</").append(CONFIG_ELEM).append(">\n");
                }
            }
            if (config.supportsAppVars()) {
                iter = config.appVarNames();
                while (iter.hasNext()) {
                    AppVar var = config.getAppVar(iter.next());
                    buff.append("\t<").append(VAR_ELEM).append(" ").append(NAME_ATTR).append("=\"").append(var.getName()).append("\" ").append(TYPE_ATTR).append("=\"").append((Object)var.getType()).append("\">").append(var.getValue()).append("</var>\n");
                }
            }
        }
        buff.append("</").append(APP_ROOT_ELEM).append(">\n");
        return buff.toString();
    }
}

