/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.common.xml;

import com.sun.jbi.common.util.I18n;
import com.sun.jbi.common.xml.XmlResource;
import com.sun.jbi.common.xml.XmlResourcePool;
import com.sun.jbi.common.xml.XmlResourcePoolImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlUtil {
    private static Logger mLogger = Logger.getLogger(XmlUtil.class.getName());
    private static TransformerFactory mTransFact = XmlUtil.newTransformerFactory();
    private static ErrorListener mErrorListener = new ErrorListener(){

        public void warning(TransformerException exception) throws TransformerException {
            mLogger.log(Level.WARNING, "WARNING", exception);
        }

        public void fatalError(TransformerException exception) throws TransformerException {
            mLogger.log(Level.SEVERE, "FATAL", exception);
        }

        public void error(TransformerException exception) throws TransformerException {
            mLogger.log(Level.SEVERE, "ERROR", exception);
        }
    };
    private static XmlResourcePool mPool = new XmlResourcePoolImpl(10);

    private XmlUtil() {
    }

    public static DocumentFragment createDocumentFragment(NodeList nodes) {
        if (nodes != null) {
            Node frag = null;
            int n = nodes.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = nodes.item(i);
                if (!(node instanceof Element)) continue;
                if (frag == null) {
                    frag = node.getOwnerDocument().createDocumentFragment();
                }
                frag.appendChild(node);
            }
            return frag;
        }
        return null;
    }

    public static XmlResourcePool getXmlResourcePool() {
        return mPool;
    }

    public static Document newDocument() {
        return XmlUtil.newDocBuilder().newDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DocumentBuilder newDocBuilder() {
        XmlResource xml = null;
        try {
            xml = XmlUtil.getXmlResourcePool().acquireXmlResource();
            DocumentBuilder documentBuilder = xml.getDocumentBuilder();
            return documentBuilder;
        }
        finally {
            XmlUtil.getXmlResourcePool().releaseXmlResource(xml);
            xml = null;
        }
    }

    public static TransformerFactory newTransformerFactory() {
        return TransformerFactory.newInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String print(Source src) {
        try {
            Transformer transformer = null;
            TransformerFactory transformerFactory = mTransFact;
            synchronized (transformerFactory) {
                transformer = mTransFact.newTransformer();
                transformer.setErrorListener(mErrorListener);
            }
            StringWriter writer = new StringWriter();
            StreamResult dest = new StreamResult(writer);
            transformer.transform(src, dest);
            XmlUtil.reset(src);
            return writer.toString();
        }
        catch (Exception e) {
            if (mLogger.isLoggable(Level.FINE)) {
                mLogger.fine("UTIL-3005: Generation of xml string failed: " + e.getMessage());
            }
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document readXml(InputStream stream) throws Exception {
        Document expectedDoc = null;
        XmlResource xml = null;
        try {
            xml = XmlUtil.getXmlResourcePool().acquireXmlResource();
            expectedDoc = xml.getDocumentBuilder().parse(stream);
        }
        finally {
            XmlUtil.getXmlResourcePool().releaseXmlResource(xml);
            xml = null;
        }
        return expectedDoc;
    }

    public static void reset(Source src) throws IOException {
        if (src instanceof StreamSource) {
            try {
                Reader reader;
                StreamSource stream = (StreamSource)src;
                InputStream inputStream = stream.getInputStream();
                if (inputStream != null) {
                    inputStream.reset();
                }
                if ((reader = stream.getReader()) != null) {
                    reader.reset();
                }
            }
            catch (IOException e) {
                String msg = I18n.loc("UTIL-6011: Failed to reset StreamSource: {0}", e.getMessage());
                mLogger.log(Level.WARNING, msg);
                if (mLogger.isLoggable(Level.FINE)) {
                    mLogger.log(Level.FINE, "UTIL-3007: StreamSource reset failure stacktrace is below", e);
                }
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DOMSource toDOMSource(Source src) throws Exception {
        try {
            if (src instanceof DOMSource) {
                return (DOMSource)src;
            }
            Transformer transformer = null;
            TransformerFactory transformerFactory = mTransFact;
            synchronized (transformerFactory) {
                transformer = mTransFact.newTransformer();
                transformer.setErrorListener(mErrorListener);
            }
            DOMResult result = new DOMResult(XmlUtil.newDocument());
            transformer.transform(src, result);
            return new DOMSource((Document)result.getNode());
        }
        catch (Exception e) {
            String msg = I18n.loc("UTIL-6010: Failed to convert to DOMSource: {0}", e.getMessage());
            mLogger.log(Level.WARNING, msg);
            if (mLogger.isLoggable(Level.FINE)) {
                mLogger.log(Level.FINE, "UTIL-3006: DOMSource convert failure stacktrace is below", e);
            }
            throw e;
        }
    }
}

