/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.common.qos.descriptor.parsers;

import com.sun.jbi.common.qos.redelivery.Redelivery;
import com.sun.jbi.common.qos.redelivery.RedeliveryConfig;
import com.sun.jbi.common.qos.redelivery.Redirect;
import com.sun.jbi.common.util.Util;
import com.sun.jbi.common.xml.StackableParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class RedeliveryParser
extends StackableParser {
    public static final String REDELIVERY_ELEM = "redelivery";
    public static final String MAX_ATTEMPTS_ATTR = "maxAttempts";
    public static final String WAIT_TIME_ATTR = "waitTime";
    public static final String REDIRECT_ELEM = "redirect";
    public static final String SUSPEND_ELEM = "suspend";
    public static final String DELETE_ELEM = "delete";
    public static final String ERROR_ELEM = "error";
    public static final String OPERATION_ATTR = "operation";
    private int mMaxAttempts;
    private long mWaitTime;
    private Redirect mRedirect;
    private RedeliveryConfig.Failure mFailure = RedeliveryConfig.Failure.error;

    public RedeliveryParser() {
        super(null);
    }

    public RedeliveryParser(StackableParser parent) {
        super(parent);
    }

    public StackableParser newInstance(StackableParser parent) {
        return new RedeliveryParser(parent);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ((qName = this.stripPrefix(qName)).equals(REDELIVERY_ELEM)) {
            this.mMaxAttempts = Util.parseInt((String)attributes.getValue(MAX_ATTEMPTS_ATTR), (int)0);
            this.mWaitTime = Util.parseLong((String)attributes.getValue(WAIT_TIME_ATTR), (long)0L);
        } else if (qName.equals(REDIRECT_ELEM)) {
            this.mFailure = RedeliveryConfig.Failure.redirect;
            this.mRedirect = new Redirect(this.resolveEndpoint(attributes, false), attributes.getValue(OPERATION_ATTR));
            this.setValue(this.mRedirect);
        } else if (qName.equals(DELETE_ELEM)) {
            this.mFailure = RedeliveryConfig.Failure.delete;
            this.setValue((Object)this.mFailure);
        } else if (qName.equals(SUSPEND_ELEM)) {
            this.mFailure = RedeliveryConfig.Failure.suspend;
            this.setValue((Object)this.mFailure);
        } else if (qName.equals(ERROR_ELEM)) {
            this.mFailure = RedeliveryConfig.Failure.error;
            this.setValue((Object)this.mFailure);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.stripPrefix(qName).equals(REDELIVERY_ELEM)) {
            this.setValue(Redelivery.createRedeliveryConfig(this.mMaxAttempts, this.mWaitTime, this.mFailure, this.mRedirect));
        }
    }

    protected void acceptValue(Object obj) {
        if (obj instanceof RedeliveryConfig.Failure) {
            this.mFailure = (RedeliveryConfig.Failure)((Object)obj);
        } else if (obj instanceof Redirect) {
            this.mRedirect = (Redirect)obj;
            this.mFailure = RedeliveryConfig.Failure.redirect;
        } else {
            super.acceptValue(obj);
        }
    }
}

