/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc.validator.soapvalidators;

import com.sun.jbi.httpsoapbc.validator.Visitable;
import com.sun.jbi.httpsoapbc.validator.Visitor;
import com.sun.jbi.httpsoapbc.validator.soapvalidators.HttpSoapBodyValidator;
import com.sun.jbi.httpsoapbc.validator.soapvalidators.HttpSoapHeaderFaultValidator;
import com.sun.jbi.httpsoapbc.validator.soapvalidators.MessagePart;
import com.sun.jbi.httpsoapbc.validator.soapvalidators.ValidatorObserver;
import com.sun.jbi.internationalization.Messages;
import com.sun.jbi.wsdlvalidator.ValidationException;
import com.sun.jbi.wsdlvalidator.Validator;
import java.util.LinkedList;
import java.util.List;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPHeaderFault;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpSoapHeaderValidator
implements Validator,
ValidatorObserver,
Visitable,
Visitor {
    private static final Messages mMessages = Messages.getMessages(HttpSoapHeaderValidator.class);
    private final List<ValidatorObserver> mObservers = new LinkedList<ValidatorObserver>();
    private final HttpSoapHeaderFaultValidator mHeaderFaultValidator = new HttpSoapHeaderFaultValidator();
    private MessagePart mPart;

    public HttpSoapHeaderValidator() {
        this.mHeaderFaultValidator.attachObserver(this);
        this.attachObserver(this.mHeaderFaultValidator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(ExtensibilityElement element) throws ValidationException {
        this.mPart = null;
        SOAPHeader header = (SOAPHeader)element;
        QName message = header.getMessage();
        if (message == null) {
            throw new ValidationException(mMessages.getString("HTTPBC-E00287.Message_missing", (Object)"<soap:header>"));
        }
        String part = header.getPart();
        if (part == null || "".equals(part)) {
            throw new ValidationException(mMessages.getString("HTTPBC-E00288.Part_missing", (Object)"<soap:header>"));
        }
        HttpSoapHeaderValidator httpSoapHeaderValidator = this;
        synchronized (httpSoapHeaderValidator) {
            this.mPart = new MessagePart(header.getMessage(), part);
        }
        this.notifyObservers();
        String use = header.getUse();
        if (use == null) {
            throw new ValidationException(mMessages.getString("HTTPBC-E00289.Use_missing", (Object)"<soap:header>"));
        }
        if (!use.equals("literal") && !use.equals("encoded")) {
            throw new ValidationException(mMessages.getString("HTTPBC-E00284.Unsupported_use_attribute", new Object[]{"<soap:header>", use}));
        }
        List faults = header.getSOAPHeaderFaults();
        for (SOAPHeaderFault fault : faults) {
            this.mHeaderFaultValidator.validate((ExtensibilityElement)fault);
        }
    }

    public HttpSoapHeaderFaultValidator getHeaderFaultValidator() {
        return this.mHeaderFaultValidator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachObserver(ValidatorObserver observer) {
        if (observer != null) {
            List<ValidatorObserver> list = this.mObservers;
            synchronized (list) {
                this.mObservers.remove(observer);
                this.mObservers.add(observer);
            }
        }
    }

    @Override
    public void notify(Object subject) throws ValidationException {
        if (subject instanceof Visitable) {
            ((Visitable)subject).accept(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MessagePart getPart() {
        HttpSoapHeaderValidator httpSoapHeaderValidator = this;
        synchronized (httpSoapHeaderValidator) {
            return this.mPart;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyObservers() throws ValidationException {
        List<ValidatorObserver> list = this.mObservers;
        synchronized (list) {
            for (ValidatorObserver o : this.mObservers) {
                o.notify(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPart(MessagePart part, String subject) throws ValidationException {
        if (part != null) {
            MessagePart aPart;
            HttpSoapHeaderValidator httpSoapHeaderValidator = this;
            synchronized (httpSoapHeaderValidator) {
                aPart = this.mPart;
            }
            if (part.equals(aPart)) {
                throw new ValidationException(mMessages.getString("HTTPBC-E00285.Part_in_use", new Object[]{part.getPartName(), "<soap:header>", subject}));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkParts(List<MessagePart> parts, String subject) throws ValidationException {
        MessagePart aPart;
        HttpSoapHeaderValidator httpSoapHeaderValidator = this;
        synchronized (httpSoapHeaderValidator) {
            aPart = this.mPart;
        }
        if (aPart == null) {
            return;
        }
        if (parts.isEmpty()) {
            throw new ValidationException(mMessages.getString("HttpSoapHeaderFaultValidator.Part_in_use", new Object[]{aPart.getPartName(), subject}));
        }
        for (MessagePart part : parts) {
            if (part == null || !part.getPartName().equals(aPart.getPartName())) continue;
            throw new ValidationException(mMessages.getString("HTTPBC-E00285.Part_in_use", new Object[]{part.getPartName(), "<soap:header>", subject}));
        }
    }

    @Override
    public void accept(Visitor visitor) throws ValidationException {
        visitor.visit(this);
    }

    @Override
    public void visit(Validator subject) throws ValidationException {
        if (subject instanceof HttpSoapHeaderFaultValidator) {
            HttpSoapHeaderFaultValidator validator = (HttpSoapHeaderFaultValidator)subject;
            String subjectName = "<soap:headerfault>";
            this.checkPart(validator.getPart(), subjectName);
        } else if (subject instanceof HttpSoapBodyValidator) {
            HttpSoapBodyValidator validator = (HttpSoapBodyValidator)subject;
            String subjectName = "<soap:body>";
            this.checkParts(validator.getParts(), subjectName);
        }
    }
}

