/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jbi.serviceengine.bridge.transport;

import com.sun.enterprise.jbi.serviceengine.bridge.transport.NMRServerConnection;
import com.sun.enterprise.jbi.serviceengine.core.ServiceEngineEndpoint;
import com.sun.enterprise.webservice.EjbRuntimeEndpointInfo;
import com.sun.logging.LogDomains;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.server.Adapter;
import com.sun.xml.ws.api.server.TransportBackChannel;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.api.server.WebServiceContextDelegate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.MessageExchange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBIAdapter
extends Adapter<WSToolkit> {
    private final Logger logger = LogDomains.getLogger((String)"javax.enterprise.system");
    private NMRServerConnection con;
    private ClassLoader classLoader;
    private EjbRuntimeEndpointInfo ejbEndPtInfo;

    public JBIAdapter(WSEndpoint endpoint, ServiceEngineEndpoint endpt, MessageExchange me, ClassLoader classLoader, EjbRuntimeEndpointInfo ejbEndPtInfo) {
        super(endpoint);
        this.con = new NMRServerConnection(me, endpt);
        this.classLoader = classLoader;
        this.ejbEndPtInfo = ejbEndPtInfo;
    }

    protected WSToolkit createToolkit() {
        return new WSToolkit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle() {
        WSToolkit tk = (WSToolkit)((Object)this.pool.take());
        try {
            tk.handle();
        }
        finally {
            this.pool.recycle((Object)tk);
        }
    }

    public void handleException(Exception ex) {
        this.con.handleException(ex);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    private void postInvoke() {
        if (this.ejbEndPtInfo != null) {
            this.ejbEndPtInfo.releaseImplementor();
        }
    }

    final class WSToolkit
    extends Adapter.Toolkit
    implements TransportBackChannel {
        WSToolkit() {
            super((Adapter)JBIAdapter.this);
        }

        public void handle() {
            Packet packet = JBIAdapter.this.con.receiveRequest();
            try {
                packet = this.head.process(packet, (WebServiceContextDelegate)JBIAdapter.this.con, (TransportBackChannel)this);
            }
            catch (Exception e) {
                JBIAdapter.this.logger.log(Level.SEVERE, "Exception in invoking the service:" + e.getMessage());
                JBIAdapter.this.postInvoke();
                JBIAdapter.this.handleException(e);
                return;
            }
            JBIAdapter.this.postInvoke();
            try {
                JBIAdapter.this.con.sendResponse(packet);
            }
            catch (Exception e) {
                JBIAdapter.this.logger.log(Level.SEVERE, e.getMessage(), e);
                JBIAdapter.this.handleException(e);
            }
        }

        public void close() {
        }
    }
}

