/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.common.util;

import com.sun.jbi.common.util.I18n;
import com.sun.jbi.common.util.Util;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.management.MBeanNames;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class MBeanHelper {
    private MBeanServer mServer;
    private MBeanNames mNames;
    private ObjectName mObjectName;
    private Map<String, ObjectName> mMBeanMap;
    private Logger mLogger;

    public MBeanHelper(ComponentContext ctx) {
        this(ctx.getMBeanServer(), ctx.getMBeanNames(), false);
        this.mLogger = Util.getLogger(ctx, MBeanHelper.class.getName());
    }

    public MBeanHelper(MBeanServer server, MBeanNames mbeanNames) {
        this(server, mbeanNames, true);
    }

    private MBeanHelper(MBeanServer server, MBeanNames mbeanNames, boolean initLog) {
        this.mServer = server;
        this.mNames = mbeanNames;
        this.mMBeanMap = new HashMap<String, ObjectName>();
        if (initLog) {
            this.mLogger = Logger.getLogger(MBeanHelper.class.getName());
        }
    }

    public ObjectName getObjectName(String mbeanName) {
        return this.mMBeanMap.get(mbeanName);
    }

    public void registerMBean(String mbeanName, Object mbean) throws JBIException {
        this.registerMBean(mbeanName, mbean, false);
    }

    public void registerMBean(String mbeanName, Object mbean, boolean force) throws JBIException {
        if (mbean != null && !Util.isEmpty(mbeanName)) {
            try {
                ObjectName objName = this.mNames.createCustomComponentMBeanName(mbeanName);
                if (force && this.mServer.isRegistered(objName)) {
                    try {
                        this.unregisterMBean(mbeanName);
                    }
                    catch (JBIException je) {
                        throw this.error(null, "UTIL-6012: Unable to register MBean, forced unregister failed for: {0}", mbeanName);
                    }
                }
                if (!this.mServer.isRegistered(objName)) {
                    this.mServer.registerMBean(mbean, objName);
                    this.mObjectName = objName;
                    this.mMBeanMap.put(mbeanName, this.mObjectName);
                }
            }
            catch (JBIException je) {
                throw je;
            }
            catch (Exception e) {
                throw this.error(e, "UTIL-6013: Failed to register MBean {0}: {1}", mbeanName, e.getMessage());
            }
        }
    }

    public void unregisterMBean(String mbeanName) throws JBIException {
        if (!Util.isEmpty(mbeanName)) {
            try {
                ObjectName objName = this.mMBeanMap.get(mbeanName);
                if (objName == null) {
                    throw this.error(null, "No MBean associated with specified name: {0}", mbeanName);
                }
                if (this.mServer.isRegistered(objName)) {
                    this.mServer.unregisterMBean(objName);
                    this.mMBeanMap.remove(mbeanName);
                }
            }
            catch (JBIException je) {
                throw je;
            }
            catch (Exception e) {
                throw this.error(e, "UTIL-6014: Failed to unregister MBean {0}: {1}", mbeanName, e.getMessage());
            }
        }
    }

    protected Logger log() {
        return this.mLogger;
    }

    private JBIException error(Exception e, String msg, Object ... params) {
        String err = I18n.loc(msg, params);
        if (e == null) {
            this.log().warning(err);
            return new JBIException(err);
        }
        this.log().log(Level.WARNING, err, e);
        return new JBIException(err, (Throwable)e);
    }
}

