/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.common.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;

public class Util {
    public static Logger getLogger(ComponentContext ctx, String logger) {
        try {
            return ctx == null ? null : ctx.getLogger(logger, null);
        }
        catch (JBIException jbi) {
            Logger log = Logger.getLogger(logger);
            if (log.isLoggable(Level.FINE)) {
                log.fine("UTIL-3001: Failed to acquire Logger from " + ctx.getComponentName() + " component context:" + jbi.getMessage());
            }
            return log;
        }
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 != null) {
            return o1.equals(o2);
        }
        return false;
    }

    public static int hashCode(Object o1) {
        return o1 == null ? 0 : o1.hashCode();
    }

    public static int parseInt(String str, int defaultValue) {
        try {
            return Util.isEmpty(str) ? defaultValue : Integer.parseInt(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static long parseLong(String str, long defaultValue) {
        try {
            return Util.isEmpty(str) ? defaultValue : Long.parseLong(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static String toString(Object[] objs, String delim) {
        if (objs == null) {
            return "";
        }
        StringBuffer buff = new StringBuffer();
        String actualDelim = "";
        buff.append("[");
        for (Object o : objs) {
            try {
                buff.append(actualDelim).append(String.valueOf(o));
            }
            catch (Exception e) {
                // empty catch block
            }
            actualDelim = delim == null ? "," : delim;
        }
        buff.append("]");
        return buff.toString();
    }

    public static String toString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static String escape(String text) {
        if (text == null) {
            return "";
        }
        StringBuffer buff = new StringBuffer();
        char[] chars = text.toCharArray();
        int n = chars.length;
        block7: for (int i = 0; i < n; ++i) {
            switch (chars[i]) {
                case '<': {
                    buff.append("&lt;");
                    continue block7;
                }
                case '>': {
                    buff.append("&gt;");
                    continue block7;
                }
                case '&': {
                    buff.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    buff.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    buff.append("&apos;");
                    continue block7;
                }
                default: {
                    buff.append(chars[i]);
                }
            }
        }
        return buff.toString();
    }
}

