/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc.security.sc.impl;

import com.sun.jbi.httpsoapbc.security.api.CredentialValidationException;
import com.sun.jbi.httpsoapbc.security.api.CredentialValidator;
import com.sun.jbi.httpsoapbc.security.api.HTTPBasicAuthCredential;
import com.sun.jbi.httpsoapbc.security.impl.UserPrincipal;
import com.sun.jbi.internationalization.Messages;
import javax.security.auth.Subject;

public class SunStringCompareCredentialValidator
implements CredentialValidator {
    private static final Messages mMessages = Messages.getMessages(SunStringCompareCredentialValidator.class);
    private String mUniqueEndpointName;
    private String mUsername;
    private char[] mPassword;

    public SunStringCompareCredentialValidator(String uniqueEndpointName, String username, char[] password) {
        this.mUniqueEndpointName = uniqueEndpointName;
        this.mUsername = username;
        this.mPassword = password;
    }

    public Subject validateCredential(String username, char[] password) throws CredentialValidationException {
        if (this.mUsername != null && password != null) {
            if (this.mUsername.equals(username) && String.valueOf(this.mPassword).equals(String.valueOf(password))) {
                Subject subj = new Subject();
                subj.getPrincipals().add(new UserPrincipal(this.mUsername));
                subj.getPrivateCredentials().add(new HTTPBasicAuthCredential(this.mUsername, this.mPassword));
                return subj;
            }
            throw new CredentialValidationException(mMessages.getString("HTTPBC-E01026.Failed_string_compare_authentication", new Object[]{username}));
        }
        throw new CredentialValidationException(mMessages.getString("HTTPBC-E01027.Failed_string_compare_invalid_config", new Object[]{username}));
    }

    public String getUsername() {
        return this.mUsername;
    }

    public char[] getPassword() {
        return this.mPassword;
    }

    public String getEndpointName() {
        return this.mUniqueEndpointName;
    }
}

