/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.common.util;

import com.sun.jbi.common.util.Util;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class LocalizationSupport {
    private PropertyResourceBundle mBundle;
    private Pattern mIdPattern;
    private String mPrefix;
    private String mBundleName;
    public static final String DEFAULTBUNDLENAME = "msgs";
    public static Pattern DEFAULTPATTERN = Pattern.compile("([A-Z]\\d\\d\\d)(: )(.*)", 32);

    protected LocalizationSupport(Pattern idpattern, String prefix, String bundlename) {
        this.mIdPattern = idpattern == null ? DEFAULTPATTERN : idpattern;
        this.mPrefix = Util.isEmpty(prefix) ? "" : prefix + "-";
        this.mBundleName = bundlename == null ? DEFAULTBUNDLENAME : bundlename;
        String packagename = this.getClass().getName();
        int lastdot = packagename.lastIndexOf(".");
        packagename = packagename.substring(0, lastdot);
        try {
            this.mBundle = (PropertyResourceBundle)ResourceBundle.getBundle(packagename + "." + this.mBundleName, Locale.getDefault(), this.getClass().getClassLoader());
        }
        catch (Exception e) {
            throw new RuntimeException("Resource bundle could not be loaded: " + e, e);
        }
    }

    protected LocalizationSupport(String prefix) {
        this(null, prefix, null);
    }

    private String salvage(Object[] args) {
        StringBuffer ret = new StringBuffer();
        ret.append(" [FORMAT ERROR.");
        if (args != null && args.length > 0) {
            ret.append(" Arguments: ");
        }
        for (int i = 0; i < args.length; ++i) {
            if (i != 0) {
                ret.append(", ");
            }
            ret.append("{").append(i).append("}=\"").append(args[i]).append("\"");
        }
        ret.append("]");
        return ret.toString();
    }

    private String format(String msg, Object[] args) {
        try {
            return MessageFormat.format(msg, args);
        }
        catch (Exception e) {
            return msg + this.salvage(args);
        }
    }

    protected String t(String msg, Object ... args) {
        try {
            String localizedmsg;
            Matcher matcher = this.mIdPattern.matcher(msg);
            if (!matcher.matches() || matcher.groupCount() <= 1) {
                return Util.isEmpty(this.mPrefix) ? "I18N: " + this.format(msg, args) : this.mPrefix + ": " + this.format(msg, args);
            }
            String msgid = matcher.group(1);
            try {
                localizedmsg = this.mBundle.getString(this.mPrefix + msgid);
            }
            catch (Exception e) {
                return this.mPrefix + this.format(msg, args);
            }
            return this.mPrefix + msgid + ":" + this.format(localizedmsg, args);
        }
        catch (Exception e) {
            return this.mPrefix + this.format(msg, args);
        }
    }
}

