/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jbi.serviceengine.work;

import com.sun.corba.ee.spi.orbutil.threadpool.NoSuchThreadPoolException;
import com.sun.corba.ee.spi.orbutil.threadpool.ThreadPool;
import com.sun.corba.ee.spi.orbutil.threadpool.ThreadPoolManager;
import com.sun.corba.ee.spi.orbutil.threadpool.Work;
import com.sun.enterprise.jbi.serviceengine.ServiceEngineException;
import com.sun.enterprise.jbi.serviceengine.comm.MessageAcceptor;
import com.sun.enterprise.jbi.serviceengine.config.ComponentConfiguration;
import com.sun.enterprise.jbi.serviceengine.work.OneWork;
import com.sun.enterprise.jbi.serviceengine.work.WorkManager;
import com.sun.enterprise.util.S1ASThreadPoolManager;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WorkManagerImpl
implements WorkManager,
Runnable {
    private ComponentConfiguration config = null;
    private String threadPoolName = null;
    private ThreadPoolManager tpm = null;
    private ThreadPool tp = null;
    private MessageAcceptor acceptor = null;
    private static Logger logger = LogDomains.getLogger((String)"javax.enterprise.system");

    public WorkManagerImpl(ComponentConfiguration config) {
        this.config = config;
        this.threadPoolName = this.config.getCommonThreadPoolName();
    }

    public void setPoolName(String poolName) {
        this.threadPoolName = poolName;
    }

    public String getPoolName() {
        return this.threadPoolName;
    }

    public MessageAcceptor getMessageAcceptor() {
        return this.acceptor;
    }

    public void submitWork(OneWork work) {
        this.tp.getAnyWorkQueue().addWork((Work)work);
    }

    public void startAcceptor() throws ServiceEngineException {
        this.tpm = S1ASThreadPoolManager.getThreadPoolManager();
        if (this.getPoolName() == null) {
            this.tp = this.tpm.getDefaultThreadPool();
        } else {
            try {
                this.tp = this.tpm.getThreadPool(this.getPoolName());
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Got the thread pool for :" + this.getPoolName());
                }
            }
            catch (NoSuchThreadPoolException e) {
                logger.log(Level.SEVERE, "workmanager.threadpool_not_found", this.getPoolName());
                throw new ServiceEngineException(e.getMessage());
            }
        }
        this.acceptor = new MessageAcceptor();
        this.acceptor.startAccepting();
    }

    public void stop() {
        this.acceptor.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.startAcceptor();
        }
        catch (ServiceEngineException se) {
            se.printStackTrace();
        }
        finally {
            this.stop();
        }
    }
}

