/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jbi.serviceengine.core;

import com.sun.enterprise.jbi.serviceengine.core.DescriptorEndpointInfo;
import com.sun.enterprise.jbi.serviceengine.core.EndpointRegistry;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JBIDescriptorReader {
    private Document mDoc;
    private DescriptorEndpointInfo[] mEPList;
    private int mNoOfConsumers;
    private int mNoOfProviders;
    private String mType;
    private String mSu_Name;
    private EndpointRegistry registry = EndpointRegistry.getInstance();
    private static final String prefix_NS = "http://javaee.serviceengine.sun.com/endpoint/naming/extension";
    private static final String ept_Mappings = "ept-mappings";
    private static final String private_Endpoints = "private-endpoints";
    private Map<String, DescriptorEndpointInfo> wsdlEndpts = this.registry.getWSDLEndpts();
    private Map<String, DescriptorEndpointInfo> jbiEndpts = this.registry.getJBIEndpts();

    JBIDescriptorReader(String su_Name) {
        this.mSu_Name = su_Name;
    }

    DescriptorEndpointInfo[] getEndpoints() {
        return this.mEPList;
    }

    int getConsumerCount() {
        return this.mNoOfConsumers;
    }

    private void setEndpoint(Node node, DescriptorEndpointInfo ep) {
        NamedNodeMap map = node.getAttributes();
        String epname = map.getNamedItem("endpoint-name").getNodeValue();
        String sername = map.getNamedItem("service-name").getNodeValue();
        String intername = map.getNamedItem("interface-name").getNodeValue();
        ep.setServiceName(new QName(this.getNamespace(sername), this.getLocalName(sername)));
        ep.setInterfaceName(new QName(this.getNamespace(intername), this.getLocalName(intername)));
        ep.setEndpointName(epname);
    }

    private void setType(String type) {
        this.mType = type;
    }

    String getType() {
        return this.mType;
    }

    private void setArtifacts() {
        String sValue;
        NodeList namelist = this.mDoc.getElementsByTagNameNS("*", "artifactstype");
        if (namelist == null) {
            this.setType("WSDL20");
            return;
        }
        Element name = (Element)namelist.item(0);
        try {
            sValue = name.getChildNodes().item(0).getNodeValue().trim();
        }
        catch (NullPointerException ne) {
            this.setType("WSDL20");
            return;
        }
        this.setType(sValue);
    }

    int getProviderCount() {
        return this.mNoOfProviders;
    }

    void init(Document doc) {
        this.mDoc = doc;
        this.mDoc.getDocumentElement().normalize();
        this.load();
    }

    void load() {
        int i;
        DescriptorEndpointInfo sb;
        Node node;
        int i2;
        NodeList providers = this.mDoc.getElementsByTagName("provides");
        this.mNoOfProviders = providers.getLength();
        NodeList consumers = this.mDoc.getElementsByTagName("consumes");
        this.mNoOfConsumers = consumers.getLength();
        this.mEPList = new DescriptorEndpointInfo[this.mNoOfConsumers + this.mNoOfProviders];
        this.setArtifacts();
        for (i2 = 0; i2 < this.mNoOfProviders; ++i2) {
            node = providers.item(i2);
            sb = new DescriptorEndpointInfo(this.mSu_Name);
            this.setEndpoint(node, sb);
            sb.setProvider();
            this.mEPList[i2] = sb;
        }
        for (i2 = 0; i2 < this.mNoOfConsumers; ++i2) {
            node = consumers.item(i2);
            sb = new DescriptorEndpointInfo(this.mSu_Name);
            this.setEndpoint(node, sb);
            this.mEPList[i2 + this.mNoOfProviders] = sb;
        }
        NodeList eptMappings = this.mDoc.getElementsByTagNameNS(prefix_NS, ept_Mappings);
        if (eptMappings.getLength() > 0) {
            eptMappings = eptMappings.item(0).getChildNodes();
        }
        for (i = 0; i < eptMappings.getLength(); ++i) {
            if (!eptMappings.item(i).getNodeName().contains("ept-mapping")) continue;
            NodeList nList = eptMappings.item(i).getChildNodes();
            DescriptorEndpointInfo dei = new DescriptorEndpointInfo(this.mSu_Name);
            DescriptorEndpointInfo dei1 = new DescriptorEndpointInfo(this.mSu_Name);
            for (int j = 0; j < nList.getLength(); ++j) {
                Node node2 = nList.item(j);
                if (node2.getNodeName().contains("java-ept")) {
                    this.setEndpoint(node2, dei);
                    String type = node2.getAttributes().getNamedItem("type").getNodeValue();
                    if (!type.equals("provider")) continue;
                    dei.setProvider();
                    dei1.setProvider();
                    continue;
                }
                if (!node2.getNodeName().contains("wsdl-ept")) continue;
                this.setEndpoint(node2, dei1);
            }
            this.wsdlEndpts.put(dei.getKey(), dei1);
            this.jbiEndpts.put(dei1.getKey(), dei);
        }
        if (!this.wsdlEndpts.isEmpty()) {
            for (i = 0; i < this.mEPList.length; ++i) {
                DescriptorEndpointInfo dei = this.mEPList[i];
                if (this.wsdlEndpts.get(dei.getKey()) == null) continue;
                this.mEPList[i] = this.wsdlEndpts.get(dei.getKey());
            }
        }
        this.processPrivateEndpoints();
    }

    private void processPrivateEndpoints() {
        NodeList privateEndpoints = this.mDoc.getElementsByTagNameNS(prefix_NS, private_Endpoints);
        if (privateEndpoints.getLength() > 0) {
            privateEndpoints = privateEndpoints.item(0).getChildNodes();
        }
        for (int i = 0; i < privateEndpoints.getLength(); ++i) {
            Node privateEndpoint = privateEndpoints.item(i);
            if (!privateEndpoint.getNodeName().contains("private-endpoint")) continue;
            DescriptorEndpointInfo dei = new DescriptorEndpointInfo(this.mSu_Name);
            this.setEndpoint(privateEndpoint, dei);
            for (int j = 0; j < this.mEPList.length; ++j) {
                if (!this.mEPList[j].equals(dei) || !this.mEPList[j].isProvider()) continue;
                this.mEPList[j].setPrivate(true);
            }
        }
    }

    private String getLocalName(String qname) {
        StringTokenizer tok = new StringTokenizer(qname, ":");
        if (tok.countTokens() == 1) {
            return qname;
        }
        tok.nextToken();
        return tok.nextToken();
    }

    private String getNamespace(String qname) {
        StringTokenizer tok = new StringTokenizer(qname, ":");
        if (tok.countTokens() == 1) {
            return "";
        }
        String prefix = tok.nextToken();
        NamedNodeMap map = this.mDoc.getDocumentElement().getAttributes();
        for (int j = 0; j < map.getLength(); ++j) {
            Node n = map.item(j);
            if (!n.getLocalName().trim().equals(prefix.trim())) continue;
            return n.getNodeValue();
        }
        return "";
    }
}

