#!/bin/bash

# if eth2 exists, and it is a igbvf device, then
# get eth0 ip, ifdown eth0, and manually configure
# eth2 with eth0's IP

if [ -e /sys/class/net/eth2 ]; then
   eth0_ip=`ip addr show dev eth0 | grep "inet " | awk '{print $2}' | awk -F/ '{print $1}'`
   if [ -z "$eth0_ip" ]; then
	echo "no ip address for eth0, exiting"
        exit 1
   fi
   def_route_gw=`ip route show | grep default | awk '{print $3}'`
   echo migrating eth0 ip $eth0_ip to eth2
   ifdown eth0
   ifconfig eth2 down
   ifconfig eth2 $eth0_ip netmask 255.255.0.0 up
   route add -net default gw $def_route_gw dev eth2
fi 

# determine which ethernet (eth1/virtio or eth3/ixgbevf) for NFS traffic
# if the eth3 device is present, assume that is the one we want
if [ -e /sys/class/net/eth3 ]; then
    nfs_eth=eth3
else
    nfs_eth=eth1
fi
if hostname | grep web; then
    tile=`hostname -s | sed -e s/vg-webt// -e s/^0*//`
    ifconfig $nfs_eth 192.132.${tile}.1 netmask 255.255.255.0 up
else
    tile=`hostname -s | sed -e s/vg-infrat// -e s/^0*//`
    ifconfig $nfs_eth 192.132.${tile}.2 netmask 255.255.255.0 up
fi
