DROP TABLE U_SEQUENCES;
CREATE TABLE U_SEQUENCES
(
   S_ID           varchar(50) not null,
   S_NEXTNUM      integer
)
TABLESPACE U_seqs_space
pctfree 98;

CREATE UNIQUE INDEX U_S_IDX ON U_SEQUENCES (S_ID)
TABLESPACE U_seqs_space;

DROP TABLE U_DATASEGMENT;
CREATE TABLE U_DATASEGMENT
(
   DS_ID          varchar(100) not null,
   DS_BLOB        clob
);
CREATE UNIQUE INDEX DS_ID_IDX ON U_DATASEGMENT (DS_ID);

DROP TABLE U_LOADER;
CREATE TABLE U_LOADER
(
    L_TXRATE      integer,
    L_ITEMCOUNT   integer,
    L_ITEMS_PER_TXRATE integer,
    L_DBIR        integer,
    L_PARALLELISM integer,
    L_IS_FF       integer,
    L_FF_DIR      varchar(1000),
    L_FF_DEL      varchar(10),
    L_IS_STANDALONE integer,
    L_DB_DRIVER_CLASS varchar(512),	
    L_DB_URL      varchar(512),	
    L_DB_USER     varchar(512),	
    L_DB_PASSWORD varchar(512),
    L_ROOT_SEED   numeric(19,0),
    L_STATUS      integer,
    L_STARTED_AT  timestamp,
    L_ENDED_AT    timestamp,
    L_VERSION     integer default 0
);
CREATE UNIQUE INDEX L_TX_IDX ON U_LOADER (L_TXRATE);

DROP TABLE U_LOAD_MESSAGE;
CREATE TABLE U_LOAD_MESSAGE
(
    LM_ID         integer,
    LM_TEXT       clob
);
CREATE UNIQUE INDEX LM_ID_IDX ON U_LOAD_MESSAGE (LM_ID);

DROP TABLE U_LOAD_SECTION;
CREATE TABLE U_LOAD_SECTION
(
    LS_ID         integer,
    LS_DOMAIN     varchar(50),
    LS_TABLENAMES varchar(200),
    LS_SECTION_ID integer,
    LS_START_STEP integer,
    LS_NUM_STEPS  integer,
    LS_STATE      integer,
    LS_VERSION    integer default 0
);
CREATE UNIQUE INDEX LS_ID_IDX ON U_LOAD_SECTION (LS_ID);
