#!/bin/sh
#
#

# Create Metadb
metadb -a -f c0t5000CCA07D1022ECd0s6 c0t5000CCA07D106778d0s7
metadb

# Initialize the sub-mirrors
metainit d1 1 2 c12t1d0s0 c13t1d0s0 -i 64k
metainit d2 1 2 c4t1d0s0  c14t1d0s0 -i 64k

# Mirror the devices
metainit d0 -m d1 d2

# Update ownership - NB: do NOT change d1 & d2
chown -R oracle:dba /dev/md/rdsk/d0

# Clear stale data
dd if=/dev/zero of=/dev/md/rdsk/d0 bs=1024k count=1024

metastat
