#!/bin/sh
#
if [ "$ORACLE_HOME" = "" ]
then
        echo "$ORACLE_HOME"
        echo "You must set the ORACLE_HOME environment variable"
        exit 1
fi

if [ "$ORACLE_SID" = "" ]
then
        echo "$ORACLE_SID"
        echo "You must set the ORACLE_SID environment variable"
        exit 1
fi

####################
# Set the database and database directory vars
#####################
DB=${ORACLE_SID}
DB_DIR="/export/home/oracle"


LOG4=${DB_DIR}/log4_${ORACLE_SID}
LOG5=${DB_DIR}/log5_${ORACLE_SID}
LOGSZ="100M"

sqlplus "/ as sysdba" <<!
alter database add logfile GROUP 4 '${LOG4}' size ${LOGSZ} reuse;
alter database add logfile GROUP 5 '${LOG5}' size ${LOGSZ} reuse;
exit;
!


