#!/bin/bash

SUDO=/usr/bin/sudo

# remove psets1-4 if already there
$SUDO psrset -f 1
$SUDO psrset -f 2
$SUDO psrset -f 3
$SUDO psrset -f 4

# pset 1: 56  cpu (7 cores) jent72
$SUDO psrset -F -c 0-55

# pset 2: 56  cpu (7 cores) jent73
$SUDO psrset -F -c 64-119

# pset 3: 56  cpu (7 cores) jent74
$SUDO psrset -F -c 128-183

# pset 4: 56  cpu (7 cores) jent75
$SUDO psrset -F -c 192-247

#Disable interrupts
echo "Disable interrupts on pset1-3"
$SUDO psrset -f 1
$SUDO psrset -f 2
$SUDO psrset -f 3
$SUDO psrset -f 4

mpstat -a

# Use 1x core per NIC intr/fanout

# configure fanout thread cpu bindings
# for the physical devices for JDBC

echo "Setup fanout for ixgbe0"
$SUDO dladm set-linkprop -p cpus=56-63 ixgbe0
$SUDO dladm set-linkprop -p cpus=56-63 ixgbe5
$SUDO dladm set-linkprop -p cpus=56-63 ixgbe8

echo "Setup fanout for ixgbe1"
$SUDO dladm set-linkprop -p cpus=120-127 ixgbe1
$SUDO dladm set-linkprop -p cpus=120-127 ixgbe6
$SUDO dladm set-linkprop -p cpus=120-127 ixgbe9

echo "Setup fanout for ixgbe3"
$SUDO dladm set-linkprop -p cpus=184-191 ixgbe3
$SUDO dladm set-linkprop -p cpus=184-191 ixgbe7
$SUDO dladm set-linkprop -p cpus=184-191 ixgbe10

echo "Setup fanout for ixgbe4"
$SUDO dladm set-linkprop -p cpus=248-255 ixgbe4
#$SUDO dladm set-linkprop -p cpus=248-255 ixgbe2
$SUDO dladm set-linkprop -p cpus=56-63,120-127,184-191,248-255 ixgbe2

