-- The column ordering here and in the loader (LoadOrders.java) must match, 
-- so that flat file generation properly maps to columns

DROP TABLE O_CUSTINVENTORY;
CREATE TABLE O_CUSTINVENTORY
(
   CI_ID          integer not null,
   CI_CUSTOMERID  integer not null,
   CI_ITEMID      char(20),
   CI_QUANTITY    integer,
   CI_VALUE       numeric(12,2),
   CI_VERSION     integer default 0
)
PARTITION by HASH (ci_customerid)
PARTITIONS 64
STORE IN (O_custinv_space)
INITRANS 20
STORAGE (INITIAL 1M NEXT 1M PCTINCREASE 0 FREELIST GROUPS 14 FREELISTS 8);

CREATE UNIQUE INDEX O_CI_IDX ON O_CUSTINVENTORY(CI_CUSTOMERID, CI_ID)
TABLESPACE O_custinv_space
INITRANS 100
STORAGE (INITIAL 1M NEXT 1M PCTINCREASE 0) LOCAL;

DROP TABLE O_CUSTOMER;
CREATE TABLE O_CUSTOMER
(
   C_ID           integer not null,
   C_FIRST        char(16),
   C_LAST         char(16),
   C_STREET1      char(20),
   C_STREET2      char(20),
   C_CITY         char(20),
   C_STATE        char(2),
   C_COUNTRY      char(10),
   C_ZIP          char(9),
   C_PHONE        char(16),
   C_CONTACT      char(25),
   C_SINCE        date,
   C_BALANCE      numeric(12,2),
   C_CREDIT       char(2),
   C_CREDIT_LIMIT numeric(12,2),
   C_YTD_PAYMENT  numeric(12,2),
   C_VERSION      integer default 0
)
TABLESPACE O_cust_space
STORAGE (INITIAL 1M NEXT 1M PCTINCREASE 0);

CREATE UNIQUE INDEX O_C_IDX ON O_CUSTOMER (C_ID)
TABLESPACE O_cust_space
INITRANS 10
STORAGE (INITIAL 1M NEXT 1M PCTINCREASE 0);

DROP TABLE O_ORDERS;
CREATE TABLE O_ORDERS
(
   O_ID           integer not null,
   O_C_ID         integer,
   O_OL_CNT       integer,
   O_DISCOUNT     numeric(4,2),
   O_TOTAL        numeric(12,2),
   O_STATUS       integer,
   O_ENTRY_DATE   timestamp,
   O_SHIP_DATE    date,
   O_VERSION      integer default 0
)
TABLESPACE O_ords_space
INITRANS 30
pctfree 75
pctused 20
PARTITION BY HASH (o_c_id)
PARTITIONS 64
STORAGE (INITIAL 1M NEXT 1M PCTINCREASE 0 FREELIST GROUPS 14 FREELISTS 8);

CREATE UNIQUE INDEX O_ORDS_IDX ON O_ORDERS (O_ID)
TABLESPACE O_ords_space
INITRANS 30
GLOBAL PARTITION BY HASH(o_id) PARTITIONS 64
STORAGE (INITIAL 1m NEXT 1m PCTINCREASE 0 FREELIST GROUPS 14 FREELISTS 8)
;

CREATE INDEX O_OC_IDX ON O_ORDERS (O_C_ID)
TABLESPACE O_ords_space
INITRANS 30
STORAGE (INITIAL 1m NEXT 1m PCTINCREASE 0 FREELIST GROUPS 14 FREELISTS 8) LOCAL
;

DROP TABLE O_ORDERLINE;
CREATE TABLE O_ORDERLINE
(
   OL_ID          integer not null,
   OL_O_ID        integer not null,
   OL_I_ID        char(20),
   OL_QTY         integer,
   OL_TOTAL_VALUE numeric(12,2),
   OL_MSRP        numeric(12,2),
   OL_STATUS      integer,
   OL_SHIP_DATE   timestamp,
   OL_VERSION     integer default 0
)
TABLESPACE O_ordl_space
pctfree 50
INITRANS 30
PARTITION BY HASH (ol_o_id)
PARTITIONS 64
STORAGE (INITIAL 1M NEXT 1M PCTINCREASE 0 FREELIST GROUPS 14 FREELISTS 8);

CREATE UNIQUE INDEX O_ORDL_IDX ON O_ORDERLINE (OL_O_ID, OL_ID)
TABLESPACE O_ordl_space
INITRANS 30
STORAGE (INITIAL 1m NEXT 1m PCTINCREASE 0 FREELIST GROUPS 14 FREELISTS 8) LOCAL;

DROP TABLE O_ITEM;
CREATE TABLE O_ITEM
(
   I_ID           char(20) not null,
   I_NAME         char(35),
   I_DESC         varchar(100),
   I_PRICE        numeric(12,2),
   I_DISCOUNT     numeric(6,4),
   I_CATEGORY     integer not null,
   I_VERSION      integer default 0
)
TABLESPACE O_item_space
STORAGE (INITIAL 1M NEXT 1M PCTINCREASE 0);

CREATE UNIQUE INDEX O_I_IDX ON O_ITEM (I_ID)
INITRANS 10
TABLESPACE O_item_space
STORAGE (INITIAL 100K NEXT 100K PCTINCREASE 0);

CREATE INDEX O_ICAT_IDX ON O_ITEM (I_CATEGORY);

