#!/bin/ksh

if [ "$#" -lt "1" ]; then
  echo "usage: $0 [ start | status | stop [ immediate | abort ] ]"
  exit;
fi


# STARTUP
if [ "$1" = "start" ]; then
sqlplus "/ as sysdba"  <<!
 startup;
!
for i in 1 2 3 4; do
  lsnrctl stop L0$i
done
set -x
/usr/bin/numactl --membind=0 --physcpubind=0-20,44-64 lsnrctl start L01 &
/usr/bin/numactl --membind=0 --physcpubind=0-20,44-64 lsnrctl start L02 &
/usr/bin/numactl --membind=1 --physcpubind=22-42,66-86 lsnrctl start L03 &
/usr/bin/numactl --membind=1 --physcpubind=22-42,66-86 lsnrctl start L04 &
set +x

sh set_ora_bkgproc.sh
sh disable_sched.sh
fi

# SHUTDOWN
if [ "$1" = "stop" ]; then
lsnrctl stop L01 &
lsnrctl stop L02 &
lsnrctl stop L03 &
lsnrctl stop L04 &
 sqlplus "/ as sysdba"  <<!
 shutdown $2;
!
fi

if [ "$1" = "status" ]
then
sqlplus "/ as sysdba"  <<!
show sga;
exit;
!

pids=`ps -ef | egrep "ora_|lsnr" | grep -v grep | awk '{print $2}'`
for pid in $pids ; do
  echo -n "`ps -ef|grep $pid | grep -v grep | awk '{print $8}'`: "
  taskset -p $pid
done
fi
