#!/bin/sh
#
SUDO=sudo
PCITOOL=/usr/sbin/pcitool

#"/pci@300/pci@1/pci@0/pci@4/pci@0/pci@c/scsi@0" 0 "mpt_sas"
#"/pci@6c0/pci@1/pci@0/pci@c/pci@0/pci@c/scsi@0" 1 "mpt_sas"

CPU_START=4
CPU_OFF=128
PSET_OFF=64

set -A nexus_arr 300 6c0
z=0
for I in 0 1
do
	# Get the MSI list for this device for Driver txns
	echo Configuring intrs for mpt_sas${I}
	NEXUS=/pci@${nexus_arr[$z]}
	ino_cnt=`$SUDO $PCITOOL $NEXUS -i | grep -c mpt_sas#${I}`
	set -A ino_arr `$SUDO $PCITOOL $NEXUS -i | grep mpt_sas#${I} | sort +0.10 | awk '{print $3}'`

	# Build the CPU array	                # cpu offset + (chip number X 128)
	CS0=$CPU_START				# 4
	CS1=`expr $CS0 + 1`			# 5
	CS2=`expr $CS0 + $PSET_OFF`		# 68
	CS3=`expr $CS2 + 1`			# 69
	CS4=`expr $CS2 + $PSET_OFF`		# 132
	CS5=`expr $CS4 + 1`			# 133
	CS6=`expr $CS4 + $PSET_OFF`		# 196
	CS7=`expr $CS6 + 1`			# 197
	CS8=`expr $CS6 + $PSET_OFF`		# 260
	CS9=`expr $CS8 + 1`			# 261
	CS10=`expr $CS8 + $PSET_OFF`		# 324
	CS11=`expr $CS10 + 1`			# 325
	CS12=`expr $CS10 + $PSET_OFF`		# 388
	CS13=`expr $CS12 + 1`			# 389
	CS14=`expr $CS12 + $PSET_OFF`		# 452
	CS15=`expr $CS14 + 1`			# 453


	echo "Targeted cpus: $CS0 $CS1 $CS2 $CS3 $CS4 $CS5 $CS6 $CS7 $CS8 $CS9 $CS10 $CS11 $CS12 $CS13 $CS14 $CS15"
	set -A cpu_arr `printf "%x %x %x %x %x %x %x %x %x %x %x %x %x %x %x %x" $CS0 $CS1 $CS2 $CS3 $CS4 $CS5 $CS6 $CS7 $CS8 $CS9 $CS10 $CS11 $CS12 $CS13 $CS14 $CS15`

	# Program the CPU binding for this MSI
	i=0
	while [ $i -lt $ino_cnt ] ; do
		$SUDO $PCITOOL $NEXUS -m ${ino_arr[$i]} -w ${cpu_arr[$i]}
		i=`expr $i + 1`
	done
	z=`expr $z + 1`
	CPU_START=`expr $CS14 + $PSET_OFF`
done

