#!/bin/sh
#
# Script to create oracle database

#if [ $# -ne 1 ]
#then
#        echo "Usage: createdb.sh <database dir>"
#        exit 1
#fi

if [ "$ORACLE_HOME" = "" ]
then
        echo "$ORACLE_HOME"
        echo "You must set the ORACLE_HOME environment variable"
        exit 1
fi

if [ "$ORACLE_SID" = "" ]
then
        echo "$ORACLE_SID"
        echo "You must set the ORACLE_SID environment variable"
        exit 1
fi

####################
# Set the database and database directory vars
#####################
DB=${ORACLE_SID}
DB_DIR=/specdb


####################################
# Check to see that the target database directory
# exists and has write permission.
####################################
if [ ! -d "$DB_DIR" ]
then
        echo "$DB_DIR does not exist. Please create it first."
        exit 1
fi


########################################################
# Go and run the create_init.sh script
# to build the correct pfiles and .ora files for Oracle
########################################################
echo "Creating the \$ORACLE_HOME/dbs .ora files ..."
#create_init.sh $DB $DB_DIR

SYS=${DB_DIR}/sys_${DB}
SYS_AUX=${DB_DIR}/sysaux_${DB}
LOG1=${DB_DIR}/LOG1
LOG2=${DB_DIR}/LOG2
TEMP=${DB_DIR}/temp_${DB}
STATS=${DB_DIR}/stats_${DB}
UNDO=${DB_DIR}/undo_${DB}
SPEC_TS=${DB_DIR}/spects_${DB}

# Create database

sqlplus <<EOT
CONNECT / as sysdba
-- shutdown;
startup nomount

CREATE DATABASE $DB
CONTROLFILE REUSE
LOGFILE GROUP 1 '${LOG1}' SIZE 300G REUSE,
        GROUP 2 '${LOG2}' SIZE 300G REUSE
MAXDATAFILES 256
DATAFILE '${SYS}' size 4G REUSE
SYSAUX DATAFILE '${SYS_AUX}' size 4G REUSE
BIGFILE DEFAULT TEMPORARY TABLESPACE temp_ts
    TEMPFILE '${TEMP}' SIZE 40G REUSE
BIGFILE UNDO TABLESPACE undo_ts DATAFILE '${UNDO}'  SIZE 100G REUSE
    BLOCKSIZE 8K;

exit
EOT


echo "Running catalog scripts ..."
sqlplus <<EOT
CONNECT / as sysdba
@?/rdbms/admin/catalog;
@?/rdbms/admin/catexp.sql
@?/rdbms/admin/catldr.sql
@?/rdbms/admin/catproc.sql
@?/rdbms/admin/catparr.sql
@?/rdbms/admin/utlmontr;
EXIT
EOT

echo "Catalog done."

sqlplus <<EOT
CONNECT / as sysdba

CREATE TABLESPACE spec_ts
        DATAFILE '${SPEC_TS}' SIZE 4096M REUSE
        EXTENT MANAGEMENT LOCAL UNIFORM SIZE 1M
        SEGMENT SPACE MANAGEMENT AUTO;

CREATE USER spec IDENTIFIED BY spec default tablespace spec_ts;
GRANT CONNECT, RESOURCE TO spec;
GRANT ALL PRIVILEGES TO spec IDENTIFIED BY spec;

CREATE TABLESPACE stats_ts
        DATAFILE '${STATS}' SIZE 4096M REUSE
        EXTENT MANAGEMENT LOCAL UNIFORM SIZE 1M;

ALTER USER spec
        TEMPORARY TABLESPACE temp_ts;
EXIT
EOT

