#!/bin/ksh

#############################################
# REGISTRY VARIABLE TUNING                  #
#############################################

db2set DB2_APM_PERFORMANCE=ON

#############################################
# DATABASE MANAGER CONFIGURATION TUNING     #
#############################################

db2 -v update dbm cfg using DFT_MON_BUFPOOL on DFT_MON_LOCK off DFT_MON_SORT off DFT_MON_STMT on DFT_MON_TIMESTAMP on DFT_MON_UOW on  DFT_MON_TABLE off 
db2 -v update dbm cfg using CPUSPEED -1
db2 -v update dbm cfg using SVCENAME 60004

db2 -v connect to specdb

############################################
# DATABASE CONFIGURATION TUNING            #
############################################

db2 -v update db cfg for specdb using LOGBUFSZ 4096
db2 -v update db cfg for specdb using SOFTMAX 200
db2 -v update db cfg for specdb using CHNGPGS_THRESH 99 
db2 -v update db cfg for specdb using LOGFILSIZ 65535
db2 -v update db cfg for specdb using LOGSECOND 0
db2 -v update db cfg for specdb using LOGPRIMARY 52
db2 -v update db cfg for specdb using AUTO_MAINT off
db2 -v update db cfg for specdb using AUTO_RUNSTATS off
db2 -v update db cfg for specdb using AUTO_TBL_MAINT off
db2 -v update db cfg for specdb using LOCKLIST 18000 MAXLOCKS 100 
db2 -v update db cfg for specdb using MINCOMMIT 1
db2 -v update db cfg for specdb using MON_REQ_METRICS none
db2 -v update db cfg for specdb using MON_ACT_METRICS none
db2 -v update db cfg for specdb using MON_OBJ_METRICS none 

############################################
# BUFFER POOL TUNING                       #
############################################

db2 -v alter bufferpool IBMDEFAULTBP immediate size 7000000
db2 -v alter bufferpool JMS_BP immediate size 45000

############################################
# TABLE TUNING                             #
############################################

db2 -v alter table O_ITEM  volatile
db2 -v alter table M_WORKORDER volatile 
db2 -v terminate
db2set DB2COMM=TCPIP
db2stop force
db2start
