#!/bin/sh


if [ $# -ne 2 ]
then
   echo "Usage: schema_TX.sh <database_name> <database dir>"
   exit 1
fi

DB=$1
DB_DIR=$2

######  datafiles #####

TX=${DB_DIR}/TXN_LOG

##############################################
#  clean up tablespaces and
#  datafiles from  earlier attempts
##############################################
db2 -v connect to ${DB}
echo "Cleaning up old table spaces"
db2 -v DROP TABLESPACE TX_space
db2 -v connect reset

#echo "Removing Datafiles"
rm -f $TX > /dev/null 2>&1

##############################################
# Create the required tablespaces
##############################################
echo "Creating TX table spaces and tables..."
# Using SMS for now (until more precise numbers are known)

db2 -v connect to ${DB}
db2 -v "CREATE TABLESPACE TX_space \
       managed by system using \
       ('$TX') \
       extentsize 320K prefetchsize 320k \
       no file system caching"
db2 -v connect reset


##############################################
# Running scripts to create schema and indexes
##############################################
db2 -v connect to ${DB}
db2 -tvf ./sql/schema_TX.sql
db2 -v connect reset

