#!/bin/bash
echo $0
db2 -v connect to specdb user db2inst1 using password
#db2 -v alter bufferpool ibmdefaultbp size 40960
#db2 -v alter bufferpool ibmdefaultbp size 819200
#db2 -v alter bufferpool ibmdefaultbp size 163840
db2 -v update db cfg for specdb using database_memory 900000
#For AUTOMATIC db2 -v alter bufferpool ibmdefaultbp size 589824
#Following is the max can be set
db2 -v alter bufferpool ibmdefaultbp size 650000
db2 -v update db cfg for specdb using newlogpath /dev/rdsk/c4t0d0s2
#Orig - 17July 2006 db2 -v update db cfg using num_iocleaners 1
db2 -v update db cfg for specdb using num_ioservers 4
db2 -v update db cfg for specdb using num_iocleaners 4
db2 -v update db cfg for specdb using softmax 600
db2 -v update db cfg for specdb using CHNGPGS_THRESH 90

###########################################
# alter table append on
echo "append on customerinventory"
db2 alter table c_customerinventory append on

echo "append on o_orders"
db2 alter table o_orders append on

echo "append on o_orderline"
db2 alter table o_orderline append on

echo "append on o_workorder"
db2 alter table m_workorder append on

echo "append on o_largeorder"
db2 alter table m_largeorder append on

echo "append on s_purschase_order"
db2 alter table s_purchase_order append on

echo "append on s_purchase_orderline"
db2 alter table s_purchase_orderline append on

# index adjustment
echo "index on m_workorder"
db2 drop index M_wo_idx
db2 "CREATE UNIQUE INDEX M_wo_idx ON M_workorder (wo_number) PCTFREE 20 LEVEL2 PCTFREE 20 PAGE SPLIT HIGH"

echo "index on m_largeorder"
db2 drop index M_lo_idx
db2 "CREATE UNIQUE INDEX M_lo_idx ON M_largeorder (lo_id) PCTFREE 20 LEVEL2 PCTFREE 20 PAGE SPLIT HIGH"

echo "index on m_largeorder"
db2 drop index M_lo_cat_idx
db2 "CREATE INDEX M_lo_cat_idx ON M_largeorder (lo_category) PCTFREE 20 LEVEL2 PCTFREE 20 PAGE SPLIT HIGH"

echo "index on m_largerorder"
db2 drop index M_OL_O_idx
db2 "CREATE UNIQUE INDEX M_OL_O_idx ON M_largeorder (lo_o_id, lo_ol_id) PCTFREE 20 LEVEL2 PCTFREE 20 PAGE SPLIT HIGH"

echo "index on o_orderline"
db2 drop index O_ordl_idx
db2 "CREATE UNIQUE INDEX O_ordl_idx ON O_orderline (ol_o_id, ol_id) PCTFREE 20 LEVEL2 PCTFREE 20 PAGE SPLIT HIGH"

echo "index on customerinventory"
db2 drop index C_ci_idx
db2 "CREATE UNIQUE INDEX C_ci_idx ON C_customerinventory(ci_id) PCTFREE 20 LEVEL2 PCTFREE 20 PAGE SPLIT HIGH"

echo "index on customerinventory"
db2 drop index c_ci_cid
db2 "CREATE INDEX C_ci_cid ON C_customerinventory(ci_customerid) PCTFREE 20 LEVEL2 PCTFREE 20 PAGE SPLIT HIGH"
####################################

db2 -v alter table m_largeorder volatile
db2 -v reorgchk update statistics on table all
db2 connect reset
db2 terminate


db2set DB2_APM_PERFORMANCE=ON
db2set DB2_RR_TO_RS=YES
db2set DB2_PARALLEL_IO=*
#db2set DB2LINUXAIO=true
db2set DB2_SCATTERED_IO=ON
db2set DB2_EXTENDED_OPTIMIZATION=ON

db2stop

echo "Flushing raw logs"
#Dileep - dd if=/dev/zero of=/dev/raw/raw1 bs=256k count=1000
#dd if=/dev/zero of=/dev/md/rdsk/d106 bs=256k count=1000
#dd if=/dev/zero of=/dev/rdsk/c2t40d0s6 bs=256k count=1000
dd if=/dev/zero of=/dev/rdsk/c4t0d0s2 bs=256k count=1000


db2start

echo "Filling specdblog"
db2 connect to specdb
db2 connect reset

echo "Activating dbs"
db2 -v activate db specdb

