#!/bin/bash

# make sure that db2 is running before executing
db2stop
db2start
db2 -v activate db specdb3k

# db2 tuning script

db2 -v update dbm cfg using SHEAPTHRES         33761
db2 -v update dbm cfg using INTRA_PARALLEL     OFF
db2 -v update dbm cfg using MAX_QUERYDEGREE    1
db2 -v update dbm cfg using MAXAGENTS          1000
db2 -v update dbm cfg using NUM_POOLAGENTS     2000
db2 -v update dbm cfg using DFT_MON_LOCK       OFF
db2 -v update dbm cfg using DFT_MON_STMT       OFF
db2 -v update dbm cfg using DFT_MON_TABLE      OFF
db2 -v update dbm cfg using DFT_MON_UOW        OFF
db2 -v update dbm cfg using HEALTH_MON         OFF
db2 -v update dbm cfg using notifylevel        3
db2 -v update dbm cfg using DIAGLEVEL          3
db2 -v update dbm cfg using query_heap_sz      52428
db2 -v update dbm cfg using rqrioblk           4096
db2 -v update dbm cfg using aslheapsz          2000
db2 -v update dbm cfg using svcename           db2c_db2inst1 


db2 -v connect to specdb3k 
db2 -v update db cfg for specdb using database_memory 8650752
db2 -v update db cfg for specdb using dft_queryopt 0
db2 -v update db cfg for specdb using dbheap 128000
db2 -v update db cfg for specdb using locklist 16000
db2 -v update db cfg for specdb using logbufsz 4096
db2 -v update db cfg for specdb using seqdetect NO
db2 -v update db cfg for specdb using logfilsiz 65535
db2 -v update db cfg for specdb using logprimary 70
db2 -v update db cfg for specdb using newlogpath /dev/rlvspecj
db2 -v update db cfg for specdb using num_ioservers 1
db2 -v update db cfg for specdb using num_iocleaners 10
db2 -v update db cfg for specdb using softmax 3000
db2 -v update db cfg for specdb using dft_degree 1
db2 -v update db cfg for specdb using MAXLOCKS 100
db2 -v alter bufferpool ibmdefaultbp size 6815744


db2 -v reorgchk update statistics on table all
 
db2 connect reset
db2 terminate

db2set DB2_USE_ALTERNATE_PAGE_CLEANING=ON
db2set DB2_NUM_CKPW_DAEMONS=0
db2set DB2_APM_PERFORMANCE=1,2,3,4,5,6,7,9
db2set DB2_EXTENDED_OPTIMIZATION=ON
db2set DB2_RR_TO_RS=YES
db2set DB2_UOW_LOGSPACE_CACHE=14336
db2set DB2_PARALLEL_IO=*
db2set db2comm=tcpip

db2stop
db2start

echo "Filling specdblog"
db2 connect to specdb3k
db2 connect reset

echo "Activating dbs"
db2 -v activate db specdb3k


