#!/bin/sh
#

if [ $# -ne 1 ]
then
	echo "Usage: createdb.sh <database dir>"
	exit 1
fi

if [ "$ORACLE_HOME" = "" ]
then
	echo "$ORACLE_HOME"
	echo "You must set the ORACLE_HOME environment variable"
	exit 1
fi

if [ "$ORACLE_SID" = "" ]
then
	echo "$ORACLE_SID"
	echo "You must set the ORACLE_SID environment variable"
	exit 1
fi

####################
# Set the database and database directory vars
#####################
DB=${ORACLE_SID}
DB_DIR=$1

######  datafiles #####

# CUST=${DB_DIR}/C_cust
# CUSTINV=${DB_DIR}/C_custinv
# SUPP=${DB_DIR}/C_supp
# SITE=${DB_DIR}/C_site
# PARTS=${DB_DIR}/C_parts

# new pointers for SPECJAppServer2004 on HP-UX Itanium 5/2/05 smc

CUST=/dev/rax/raw11
CUSTINV=/dev/rax/raw21
CUSTINVA=/dev/rax/raw21a
SUPP=/dev/rax/raw12
SITE=/dev/rax/raw13
PARTS=/dev/rax/raw14


#sqlplus '/ as sysdba'  <<EOT  
#shutdown
#startup
#EOT

sqlplus '/ as sysdba'  <<EOT 
DROP TABLESPACE C_cust_space INCLUDING CONTENTS;
DROP TABLESPACE C_custinv_space INCLUDING CONTENTS;
DROP TABLESPACE C_supp_space INCLUDING CONTENTS;
DROP TABLESPACE C_site_space INCLUDING CONTENTS;
DROP TABLESPACE C_parts_space INCLUDING CONTENTS;

CREATE TABLESPACE C_cust_space
	DATAFILE '${CUST}' SIZE 4990M REUSE
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M SEGMENT SPACE MANAGEMENT AUTO;
CREATE TABLESPACE C_custinv_space
	DATAFILE '${CUSTINV}' SIZE 7490M REUSE
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M SEGMENT SPACE MANAGEMENT AUTO;
ALTER TABLESPACE C_custinv_space ADD DATAFILE '${CUSTINVA}' SIZE 7490M REUSE;
CREATE TABLESPACE C_parts_space
	DATAFILE '${PARTS}' SIZE 1990M REUSE 
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M SEGMENT SPACE MANAGEMENT AUTO;
CREATE TABLESPACE C_supp_space
	DATAFILE '${SUPP}' SIZE 10M REUSE 
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 1M SEGMENT SPACE MANAGEMENT AUTO;
CREATE TABLESPACE C_site_space
	DATAFILE '${SITE}' SIZE 10M REUSE 
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 1M SEGMENT SPACE MANAGEMENT AUTO;
EXIT
EOT

wait

##############################################
# Running scripts to create schema and indexes
##############################################
sqlplus spec04/spec04 <<EOT
@sql04/schema_C
EOT
