#!/bin/sh
#

if [ $# -ne 1 ]
then
	echo "Usage: createdb.sh <database dir>"
	exit 1
fi

if [ "$ORACLE_HOME" = "" ]
then
	echo "$ORACLE_HOME"
	echo "You must set the ORACLE_HOME environment variable"
	exit 1
fi

if [ "$ORACLE_SID" = "" ]
then
	echo "$ORACLE_SID"
	echo "You must set the ORACLE_SID environment variable"
	exit 1
fi

####################
# Set the database and database directory vars
#####################
DB=${ORACLE_SID}
DB_DIR=$1

######  datafiles #####
# UTABS=${DB_DIR}/U_tables

# new pointers for SPECJAppServer2004 on HP-UX Itanium 5/2/05 smc

UTABS=/dev/raw/raw30

#sqlplus '/ as sysdba'  <<EOT  
#shutdown
#startup 
#EOT

sqlplus '/ as sysdba'  <<EOT 

DROP TABLESPACE U_space INCLUDING CONTENTS;
CREATE TABLESPACE U_space
	DATAFILE '${UTABS}' SIZE 200M REUSE
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M;
EXIT
EOT

##############################################
# Running scripts to create schema and indexes
##############################################
sqlplus spec04/spec04 <<EOT
@sql04/schema_U
EOT
