#!/bin/sh
#
# Script to create oracle database

if [ $# -ne 1 ]
then
	echo "Usage: createdb.sh <database dir>"
	exit 1
fi

if [ "$ORACLE_HOME" = "" ]
then
	echo "$ORACLE_HOME"
	echo "You must set the ORACLE_HOME environment variable"
	exit 1
fi

if [ "$ORACLE_SID" = "" ]
then
	echo "$ORACLE_SID"
	echo "You must set the ORACLE_SID environment variable"
	exit 1
fi

####################
# Set the database and database directory vars
#####################
DB=${ORACLE_SID}
DB_DIR=$1

###################################################
# If the database already exists warn that we will 
# destroy it.
####################################################
if [ -f "$ORACLE_HOME"/dbs/init${DB}.ora  ]
then
	echo  "$ORACLE_HOME"/dbs/init${DB}.ora
	echo "Database already exists. Ok to destroy y/n ? \c"
	read junk
	if [ "$junk" != 'y' -a "$junk" != 'Y' ]
	then
		echo  "database create cancelled"
		exit 1
	fi
fi

####################################
# Check to see that the target database directory
# exists and has write permission.
####################################
# if [ ! -d "$DB_DIR" ] 
# then
# 	echo "$DB_DIR does not exist. Please create it first."
# 	exit 1
# fi


########################################################
# Go and run the create_init.sh script
# to build the correct pfiles and .ora files for Oracle 
########################################################
echo "Creating the \$ORACLE_HOME/dbs .ora files ..."
create_init.sh $DB $DB_DIR

# SYS=${DB_DIR}/sys_${DB}
# SYS_AUX=${DB_DIR}/sysaux_${DB}
# LOG1=${DB_DIR}/log1_${DB}
# LOG2=${DB_DIR}/log2_${DB}
# TEMP=${DB_DIR}/temp_${DB}
# STATS=${DB_DIR}/stats_${DB}
# UNDO=${DB_DIR}/undo_${DB}

# new pointers for SPECJAppServer2004 on HP-UX Itanium 5/2/05 smc

SYS=/dev/raw/raw1
SYS_AUX=/dev/raw/raw6
LOG1=/dev/ray/raw31
LOG2=/dev/ray/raw32
TEMP=/dev/raw/raw8
STATS=/dev/raw/raw7
UNDO=/dev/raw/raw3
UNDO1=/dev/raw/raw4

# Create database
# LOGFILE GROUP 1 '${LOG1}' SIZE 99000M REUSE,
#        GROUP 2 '${LOG2}' SIZE 99000M REUSE

sqlplus <<EOT
CONNECT / as sysdba
startup nomount

CREATE DATABASE $DB
CONTROLFILE REUSE
LOGFILE GROUP 1 '${LOG1}' SIZE 10M REUSE,
        GROUP 2 '${LOG2}' SIZE 10M REUSE
MAXDATAFILES 256
DATAFILE '${SYS}' size 2000M REUSE
SYSAUX DATAFILE '${SYS_AUX}' size 2000M REUSE
DEFAULT TEMPORARY TABLESPACE temp_ts
    TEMPFILE '${TEMP}' SIZE 500M REUSE
UNDO TABLESPACE undo_ts DATAFILE '${UNDO}'  SIZE 7000M REUSE
    BLOCKSIZE 8K;

exit
EOT


echo "Running catalog scripts ..."
sqlplus <<EOT
CONNECT / as sysdba
@?/rdbms/admin/catalog;
@?/rdbms/admin/catexp.sql
@?/rdbms/admin/catldr.sql
@?/rdbms/admin/catproc.sql
@?/rdbms/admin/catparr.sql
@?/rdbms/admin/utlmontr;
EXIT
EOT

echo "Catalog done."

sqlplus <<EOT
CONNECT / as sysdba
CREATE USER spec IDENTIFIED BY spec;
GRANT CONNECT, RESOURCE TO spec;
GRANT ALL PRIVILEGES TO spec IDENTIFIED BY spec;

CREATE USER spec04 IDENTIFIED BY spec04;
GRANT CONNECT, RESOURCE TO spec04;
GRANT ALL PRIVILEGES TO spec04 IDENTIFIED BY spec04;

CREATE TABLESPACE stats_ts
        DATAFILE '${STATS}' SIZE 1980M REUSE
        EXTENT MANAGEMENT LOCAL UNIFORM SIZE 1M;

alter TABLESPACE UNDO_TS
        add DATAFILE '${UNDO1}' SIZE 7000M REUSE;

ALTER USER spec
	TEMPORARY TABLESPACE temp_ts;
ALTER USER spec04
	TEMPORARY TABLESPACE temp_ts;
EXIT
EOT
