DROP TABLE C_customerinventory;
CREATE TABLE C_customerinventory
(
        ci_id 		integer not null,
        ci_itemid 	char(20),
        ci_quantity	integer,
        ci_customerid	integer,
        ci_value 		numeric(12,2)
)
in C_custinv_space;

CREATE UNIQUE INDEX C_ci_idx ON C_customerinventory(ci_id);
CREATE INDEX C_ci_cid ON C_customerinventory(ci_customerid);

DROP TABLE C_customer;
CREATE TABLE C_customer
(
        c_id            integer not null,
        c_first         varchar(16),   
        c_last          varchar(16),
        c_street1       varchar(20),
        c_street2       varchar(20),
        c_city          varchar(20),
        c_state         char(2),
        c_country       varchar(10),
        c_zip           varchar(9),
        c_phone         varchar(16),
        c_contact       varchar(25),
        c_since         date,
        c_balance       numeric(12,2),
        c_credit        char(2),
        c_credit_limit  numeric(12,2),
        c_ytd_payment   numeric(12,2)
)
in C_cust_space;

CREATE UNIQUE INDEX C_c_idx ON C_customer (c_id);

DROP TABLE C_supplier;
CREATE TABLE C_supplier
(
        supp_id                 integer not null,
        supp_name               varchar(16),
        supp_street1    varchar(20),
        supp_street2    varchar(20),
        supp_city               varchar(20),
        supp_state              char(2),
        supp_country    varchar(10),
        supp_zip                varchar(9),
        supp_phone              varchar(16),
        supp_contact    varchar(25)
)
in C_supp_space;

CREATE UNIQUE INDEX C_supp_idx ON C_supplier (supp_id);

DROP TABLE C_site;
CREATE TABLE C_site
(
        site_id                 integer not null,
        site_name               varchar(16),
        site_street1    varchar(20),
        site_street2    varchar(20),
        site_city               varchar(20),
        site_state              char(2),
        site_country    varchar(10),
        site_zip                varchar(9)
)
in C_site_space;

CREATE UNIQUE INDEX C_site_idx ON C_site (site_id);

DROP TABLE C_parts;
CREATE TABLE C_parts
(
        p_id                    char(20) not null,
        p_name                  varchar(35),
        p_desc                  varchar(100),
        p_rev                   varchar(6),
        p_unit                  varchar(10),
        p_cost                  numeric(12,2),
        p_price                 numeric(12,2),
        p_planner               integer,
        p_type                  integer,
        p_ind                   integer,
        p_lomark                integer,
        p_himark                integer
)
in C_parts_space;

CREATE UNIQUE INDEX C_p_idx ON C_parts (p_id);
