#!/bin/sh
#

if [ $# -ne 1 ]
then
	echo "Usage: createdb.sh <database dir>"
	exit 1
fi

if [ "$ORACLE_HOME" = "" ]
then
	echo "$ORACLE_HOME"
	echo "You must set the ORACLE_HOME environment variable"
	exit 1
fi

if [ "$ORACLE_SID" = "" ]
then
	echo "$ORACLE_SID"
	echo "You must set the ORACLE_SID environment variable"
	exit 1
fi

####################
# Set the database and database directory vars
#####################
DB=${ORACLE_SID}
DB_DIR=$1

######  datafiles #####
UTABS=${DB_DIR}/U_tables

#sqlplus '/ as sysdba'  <<EOT  
#shutdown
#startup 
#EOT

sqlplus '/ as sysdba'  <<EOT 

DROP TABLESPACE U_space INCLUDING CONTENTS;
CREATE TABLESPACE U_space
	DATAFILE '${UTABS}' SIZE 100M REUSE
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M;
EXIT
EOT

##############################################
# Running scripts to create schema and indexes
##############################################
sqlplus spec/spec <<EOT
@sql/schema_U
EOT
