#!/bin/sh
if [ $# -ne 2 ]
then
	echo "Usage: crrb.sh <database_name> <database dir>"
	exit 1
fi

if [ "$ORACLE_HOME" = "" ]
then
	echo "$ORACLE_HOME"
	echo "You must set the ORACLE_HOME environment variable"
	exit 1
fi


####################
# Set the database and database directory vars
#####################
DB=$1
DB_DIR=$2
ORACLE_SID=$DB
export ORACLE_SID

if [ ! -d "$DB_DIR" ] 
then
	echo "$DB_DIR does not exist. Please create it first."
	exit 1
fi


UNDO=${DB_DIR}/rbs_${DB}

# Create database
sqlplus <<EOT
CONNECT / as sysdba
spool crrbs
alter rollback segment rbs_sys1 offline;
drop rollback segment rbs_sys1;
alter rollback segment rbs_sys2 offline;
drop rollback segment rbs_sys2;
create rollback segment rbs_sys1 tablespace system storage (initial 10M next 10M maxextents unlimited );
create rollback segment rbs_sys2 tablespace system storage (initial 10M next 10M maxextents unlimited ) ;
alter rollback segment rbs_sys1 online;
alter rollback segment rbs_sys2 online;
drop tablespace rbs_ts including contents;
create tablespace rbs_ts datafile '${UNDO}' SIZE 1100M REUSE extent management local uniform size 1M ;
@rbs.sql
exit
EOT
