#!/bin/sh
# set -x
BINDIR=`dirname $0`

if [ -n "$BINDIR" ]
then
    JAS_HOME=`cd $BINDIR/.. > /dev/null 2>&1 && pwd`
    export JAS_HOME
fi
echo JAS_HOME is  ${JAS_HOME}

# Configuration file location
CONFIG_DIR=${JAS_HOME}/config

# We check for the apps server and load the necessary environment
# to make a run
APPSSERVER=`cat ${CONFIG_DIR}/appsserver`
echo "Apps server is ${APPSSERVER}"

ENVFILE=${CONFIG_DIR}/${APPSSERVER}.env

if [ ! -f ${ENVFILE} ] ; then
    echo "Cannot find config/${APPSSERVER}.env" >&2
    exit 1
fi

. ${ENVFILE}

# We check for JAVA_HOME. If not set, we do not
# continue processing.

CHECKPASSED=1
if [ -z "${JAVA_HOME}" ] ; then
    echo "JAVA_HOME not set" >&2
    exit 1
fi

echo $CLASSPATH

echo ".........Enabling table locks..................."
rsh -l oracle db_host ". ./.oraenv.${DB_VER}; tbllke.sh"

${JAVA_HOME}/bin/java -classpath ${JAS_HOME}/jars/launcher.jar -Dspecjappserver.home=${JAS_HOME} org.spec.jappserver.launcher.Script DBLoader $*

echo ".........Disabling table locks.................."
rsh -l oracle db_host ". ./.oraenv.${DB_VER}; tbllkd.sh"
