DROP TABLE O_customer;
CREATE TABLE O_customer
(
	C_ID		integer not null,
	C_FIRST		char(16),
	C_LAST		char(16),
	C_STREET1	char(20),	
	C_STREET2	char(20),	
	C_CITY		char(20),	
	C_STATE		char(2),	
	C_COUNTRY	char(10),	
	C_ZIP		char(9),	
	C_PHONE		char(16),
	C_CONTACT	char(25),
	C_SINCE		date,
	primary key (C_ID)
) TYPE = InnoDB;

/* CREATE UNIQUE INDEX O_C_IDX ON O_customer (C_ID); */

DROP TABLE O_orders;
CREATE TABLE O_orders
(
	O_ID		integer not null,
	O_C_ID		integer,
	O_OL_CNT	integer,
	O_DISCOUNT	numeric(4,2),
	O_TOTAL		numeric(9,2),
	O_STATUS	integer,
	O_ENTRY_DATE	datetime,
	O_SHIP_DATE	date,
	primary key (O_ID)
) TYPE = InnoDB;

/* CREATE UNIQUE INDEX O_ORDS_IDX ON O_orders (O_ID); */

CREATE INDEX O_OC_IDX ON O_orders (O_C_ID);

DROP TABLE O_orderline;
CREATE TABLE O_orderline
(
	OL_ID		integer not null,
	OL_O_ID		integer not null,
	OL_I_ID		char(15),
	OL_QTY		integer,
	OL_STATUS	integer,
	OL_SHIP_DATE	date,
	primary key (OL_O_ID, OL_ID)
) TYPE = InnoDB;

/* CREATE UNIQUE INDEX O_ORDL_IDX ON O_orderline (OL_O_ID, OL_ID); */

DROP TABLE O_item;
CREATE TABLE O_item
(
	I_ID			char(15) not null,
	I_NAME			char(20),
	I_DESC			varchar(100),
	I_PRICE			numeric(9,2),
	I_DISCOUNT		numeric(6,4),
	primary key (I_ID)
) TYPE = InnoDB;

/* CREATE UNIQUE INDEX O_I_IDX ON O_item (I_ID); */
